import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {graphql, compose} from "react-apollo";
import gql from "graphql-tag";
import {Form, TextArea} from 'react-form';
import Loading from "../../../../core/Loading/Loading";
import UsersForm from "../../../../core/Forms/UsersForm/UsersForm";
import {rolesQuery} from "../../../../api/queries";

export default class Create extends Component {

  constructor(props) {
    super(props);

    this.state = {
      submitting: false,
      error: false,
    };
  }

  render() {

    return (
      <div className="container" style={{marginBottom: '20px'}}>
        <h1>Nuovo Utente</h1>
        <UsersForm
          errorMessage={"Errore durante la creazione dell'utente"}
          data={this.props.data}
          submitMutation={gql`
                    mutation($utente: UtenteInput) {
                        updateUtente(monitoraggioSpecie: $utente) {
                            id
                        }
                    }`} />
      </div>
    )
  }
}

Create.defaultProps = {};

Create.propTypes = {};